﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Drawing;
using System.Web.SessionState;

namespace AZVIC.Ei8htPOS.WebUI.WebService
{
    /// <summary>
    /// Summary description for captcha
    /// </summary>
    public class Captcha : IHttpHandler, IRequiresSessionState
    {
        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "image/jpeg";
            CatpchaImage captcha = new CatpchaImage();
            string str = context.Request.QueryString["value"].ToString();

            str = captcha.DrawNumbers(5, str);

            if (context.Session[CatpchaImage.SESSION_CAPTCHA] == null)
                context.Session.Add(CatpchaImage.SESSION_CAPTCHA, str);
            else
            {
                context.Session[CatpchaImage.SESSION_CAPTCHA] = str;
            }
            Bitmap bmp = captcha.Result;
            bmp.Save(context.Response.OutputStream, System.Drawing.Imaging.ImageFormat.Jpeg);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}